/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Tree;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Regexp
implements Serializable {
    private static final long serialVersionUID = 7660746903663279727L;
    private Language Lan;
    private GramType Type;
    private String Text;
    private transient int Position;
    private transient char LookAhead;
    public transient Gram Grm;

    private boolean match(char character) {
        ParameterCheck.mandatory("character", Character.valueOf(character));
        if (this.Position < this.Text.length() && this.Text.charAt(this.Position) == character) {
            ++this.Position;
            this.LookAhead = this.Position == this.Text.length() ? (char)'\u0000' : this.Text.charAt(this.Position);
            return true;
        }
        return false;
    }

    private boolean delim(char character) {
        ParameterCheck.mandatory("character", Character.valueOf(character));
        if (Character.isWhitespace(character)) {
            return true;
        }
        if (character == '(') {
            return true;
        }
        return character == ')';
    }

    private Tree parseExp() {
        while (Character.isWhitespace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        Tree tree1 = this.parseTerm();
        while (Character.isWhitespace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        if (this.Position == this.Text.length()) {
            return tree1;
        }
        if (this.LookAhead == '+' | this.LookAhead == '|') {
            this.match(this.LookAhead);
            while (Character.isWhitespace(this.LookAhead)) {
                this.match(this.LookAhead);
            }
            Tree tree2 = this.parseExp();
            Tree resultTree = Tree.binaryTree(tree1, tree2, "+");
            return resultTree;
        }
        return tree1;
    }

    private Tree parseTerm() {
        Tree tree1 = this.parseSubTerm();
        while (Character.isWhitespace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        if (this.Position == this.Text.length()) {
            return tree1;
        }
        if (this.LookAhead != ')' && this.LookAhead != '+' && this.LookAhead != '|') {
            Tree tree2 = this.parseTerm();
            Tree resultTree = Tree.binaryTree(tree1, tree2, ".");
            return resultTree;
        }
        return tree1;
    }

    private Tree parseSubTerm() {
        Tree tree1 = this.parseFactor();
        if (this.LookAhead == '*') {
            this.match('*');
            Tree resultTree = Tree.binaryTree(tree1, null, "*");
            return resultTree;
        }
        return tree1;
    }

    private void processOutput(StringBuilder stringBuilder) {
        ParameterCheck.mandatory("stringBuilder", stringBuilder);
        if (this.LookAhead == '\"') {
            this.match(this.LookAhead);
            while (this.LookAhead != '\u0000' && this.LookAhead != '\"') {
                stringBuilder.append(this.LookAhead);
                this.match(this.LookAhead);
            }
            this.match(this.LookAhead);
        } else {
            while (this.LookAhead != '\u0000' && !this.delim(this.LookAhead) && this.LookAhead != '|') {
                stringBuilder.append(this.LookAhead);
                this.match(this.LookAhead);
            }
        }
    }

    private Tree parseFactor() {
        Tree tree;
        switch (this.LookAhead) {
            case '(': {
                this.match('(');
                tree = this.parseExp();
                this.match(')');
                break;
            }
            case '<': {
                StringBuilder stringBuilder = new StringBuilder();
                while (this.LookAhead != '>') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                this.match(this.LookAhead);
                stringBuilder.append('>');
                if (this.LookAhead == '/') {
                    this.match(this.LookAhead);
                    stringBuilder.append('/');
                    this.processOutput(stringBuilder);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case '\"': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('\"');
                this.match(this.LookAhead);
                while (this.LookAhead != '\u0000' && this.LookAhead != '\"') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                this.match(this.LookAhead);
                stringBuilder.append('\"');
                if (this.LookAhead == '/') {
                    this.match(this.LookAhead);
                    stringBuilder.append('/');
                    this.processOutput(stringBuilder);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case ':': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(':');
                this.match(this.LookAhead);
                while (this.LookAhead != '\u0000' && !this.delim(this.LookAhead) && this.LookAhead != '|') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                if (this.LookAhead == '/') {
                    this.match(this.LookAhead);
                    stringBuilder.append('/');
                    this.processOutput(stringBuilder);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case '$': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('$');
                this.match(this.LookAhead);
                if (this.LookAhead == '(' || this.LookAhead == ')') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                    while (this.LookAhead != '\u0000' && !this.delim(this.LookAhead) && this.LookAhead != '|') {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                } else {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                    while (this.LookAhead != '\u0000' && !this.delim(this.LookAhead) && this.LookAhead != '|') {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                }
                if (this.LookAhead == '/') {
                    this.match(this.LookAhead);
                    stringBuilder.append('/');
                    this.processOutput(stringBuilder);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.Type == GramType.MORPHO) {
                    if (this.LookAhead == '\\') {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                    if (this.LookAhead == '/') {
                        this.match(this.LookAhead);
                        stringBuilder.append('/');
                        this.processOutput(stringBuilder);
                    }
                } else {
                    if (Language.isLetter(this.LookAhead) && !this.Lan.asianTokenizer) {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                        while (Language.isLetter(this.LookAhead)) {
                            stringBuilder.append(this.LookAhead);
                            this.match(this.LookAhead);
                        }
                    } else {
                        if (this.LookAhead == '\\') {
                            stringBuilder.append(this.LookAhead);
                            this.match(this.LookAhead);
                        }
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                    if (this.LookAhead == '/') {
                        this.match(this.LookAhead);
                        stringBuilder.append('/');
                        this.processOutput(stringBuilder);
                    }
                }
                tree = Tree.leafTree(stringBuilder.toString());
            }
        }
        return tree;
    }

    private static boolean gIsWhiteSpace(char character) {
        ParameterCheck.mandatory("character", Character.valueOf(character));
        return Character.isWhitespace(character) && character != '\n';
    }

    private Tree gParseExp() {
        while (Regexp.gIsWhiteSpace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        Tree tree1 = this.gParseTerm();
        while (Regexp.gIsWhiteSpace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        if (this.Position == this.Text.length()) {
            return tree1;
        }
        if (this.LookAhead == '\n') {
            this.match('\n');
            while (Regexp.gIsWhiteSpace(this.LookAhead)) {
                this.match(this.LookAhead);
            }
            Tree tree2 = this.gParseExp();
            Tree resultTree = Tree.binaryTree(tree1, tree2, "+");
            return resultTree;
        }
        return tree1;
    }

    private Tree gParseTerm() {
        Tree tree1 = this.gParseFactor();
        while (Regexp.gIsWhiteSpace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        if (this.Position == this.Text.length()) {
            return tree1;
        }
        if (this.LookAhead != '\n') {
            Tree tree2 = this.gParseTerm();
            Tree resultTree = Tree.binaryTree(tree1, tree2, ".");
            return resultTree;
        }
        return tree1;
    }

    private Tree gParseFactor() {
        Tree tree;
        switch (this.LookAhead) {
            case '<': {
                StringBuilder stringBuilder = new StringBuilder();
                while (this.LookAhead != '>') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                this.match(this.LookAhead);
                stringBuilder.append('>');
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case '\\': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.LookAhead);
                this.match(this.LookAhead);
                stringBuilder.append(this.LookAhead);
                this.match(this.LookAhead);
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case '\"': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('\"');
                this.match(this.LookAhead);
                while (this.LookAhead != '\"') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                this.match(this.LookAhead);
                stringBuilder.append('\"');
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case ':': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(':');
                this.match(this.LookAhead);
                while (this.LookAhead != '\u0000' && this.LookAhead != '\n') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            case '$': {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('$');
                this.match(this.LookAhead);
                while (this.LookAhead != '\u0000' && this.LookAhead != '\n') {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                tree = Tree.leafTree(stringBuilder.toString());
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.Type == GramType.MORPHO) {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                } else if (Language.isLetter(this.LookAhead) && !this.Lan.asianTokenizer) {
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                    while (Language.isLetter(this.LookAhead)) {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                } else {
                    if (this.LookAhead == '\\') {
                        stringBuilder.append(this.LookAhead);
                        this.match(this.LookAhead);
                    }
                    stringBuilder.append(this.LookAhead);
                    this.match(this.LookAhead);
                }
                tree = Tree.leafTree(stringBuilder.toString());
            }
        }
        return tree;
    }

    public Regexp(Language language, String regularExpression, GramType gramType) {
        ParameterCheck.mandatoryString("regularExpression", regularExpression);
        this.Lan = language;
        this.Text = regularExpression;
        this.Type = gramType;
        this.Position = 0;
        if (this.Text.equals("")) {
            return;
        }
        this.LookAhead = this.Text.charAt(0);
        while (Character.isWhitespace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        Tree T = this.parseExp();
        ArrayList<String> aVocab = new ArrayList<String>();
        aVocab.add("<E>");
        HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
        hVocab.put("<E>", 0);
        this.Grm = T.explore(aVocab, hVocab);
        this.Grm.vocab = aVocab;
        hVocab = null;
        this.Text = null;
    }

    public Regexp(String inflectionalExpression) {
        try {
            this.Lan = new Language("en");
            if (this.Lan == null) {
                System.out.println("Cannot construct language for isoname = en");
            }
        }
        catch (RuntimeException e) {
            System.out.println("Cannot construct language: " + e.getMessage());
        }
        if (this.Lan != null) {
            this.Type = GramType.FLX;
            this.Text = inflectionalExpression;
            this.Position = 0;
            if (this.Text.length() > 0) {
                this.LookAhead = this.Text.charAt(0);
                while (Character.isWhitespace(this.LookAhead)) {
                    this.match(this.LookAhead);
                }
                Tree T = this.parseExp();
                ArrayList<String> aVocab = new ArrayList<String>();
                aVocab.add("<E>");
                HashMap<String, Integer> hVocab = new HashMap<String, Integer>();
                hVocab.put("<E>", 0);
                this.Grm = T.explore(aVocab, hVocab);
                this.Grm.vocab = aVocab;
                hVocab = null;
                this.Text = null;
            } else {
                this.Grm = null;
            }
        }
    }

    Regexp(Language language, String labelIn, String labelOut, GramType gramType, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        ParameterCheck.mandatoryString("labelIn", labelIn);
        ParameterCheck.mandatory("aVocab", aVocab);
        ParameterCheck.mandatory("hVocab", hVocab);
        this.Lan = language;
        this.Text = labelIn;
        this.Type = gramType;
        this.Position = 0;
        this.LookAhead = this.Text.charAt(0);
        while (Regexp.gIsWhiteSpace(this.LookAhead)) {
            this.match(this.LookAhead);
        }
        Tree T = this.gParseExp();
        this.Grm = T.explore(labelOut, aVocab, hVocab);
        this.Grm.vocab = aVocab;
        hVocab = null;
        this.Text = null;
    }
}

